﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;

namespace CashierCrisis.Graphs
{
    public class HeuristicEuclid : IHeuristic<SparseGraph<PathNode, GraphEdge>, PathNode, GraphEdge>
    {
        #region IHeuristic<SparseGraph<PathNode,GraphEdge>,PathNode,GraphEdge> Members

        public double Calculate(SparseGraph<PathNode, GraphEdge> graph, int a, int b)
        {
            return (double)(Vector2.Distance(graph.GetNode(a).Position, graph.GetNode(b).Position));
        }

        #endregion
    }
}
